/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.demos;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.python.antlr.PythonLexer;
import org.python.antlr.PythonTree;
import org.python.antlr.RecordingErrorHandler;
import org.python.antlr.runtime.ANTLRStringStream;
import org.python.antlr.runtime.BaseRecognizer;
import org.python.antlr.runtime.CommonToken;
import org.python.antlr.runtime.RecognitionException;
import org.python.antlr.runtime.RecognizerSharedState;
import org.python.antlr.runtime.Token;
import org.python.indexer.Indexer;
import org.python.indexer.StyleRun;
import org.python.indexer.ast.DefaultNodeVisitor;
import org.python.indexer.ast.NFunctionDef;
import org.python.indexer.ast.NModule;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNum;
import org.python.indexer.ast.NStr;
import org.python.indexer.demos.DocStringParser;
import org.python.indexer.demos.Linker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Styler
extends DefaultNodeVisitor {
    static final Pattern BUILTIN = Pattern.compile("None|True|False|NotImplemented|Ellipsis|__debug__");
    private static final Pattern TRISTRING_PREFIX = Pattern.compile("^[ruRU]{0,2}['\"]{3}");
    private Indexer indexer;
    private String source;
    private String path;
    private List<StyleRun> styles = new ArrayList<StyleRun>();
    private Linker linker;
    private Set<Integer> docOffsets = new HashSet<Integer>();

    public Styler(Indexer indexer, Linker linker) {
        this.indexer = indexer;
        this.linker = linker;
    }

    public List<StyleRun> addStyles(String string, String string2) throws Exception {
        this.path = string;
        this.source = string2;
        NModule nModule = this.indexer.getAstForFile(string);
        if (nModule != null) {
            nModule.visit(this);
            this.highlightLexicalTokens();
        }
        return this.styles;
    }

    @Override
    public boolean visit(NName nName) {
        NNode nNode = nName.getParent();
        if (nNode instanceof NFunctionDef) {
            NFunctionDef nFunctionDef = (NFunctionDef)nNode;
            if (nName == nFunctionDef.name) {
                this.addStyle(nName, StyleRun.Type.FUNCTION);
            } else if (nName == nFunctionDef.kwargs || nName == nFunctionDef.varargs) {
                this.addStyle(nName, StyleRun.Type.PARAMETER);
            }
            return true;
        }
        if (BUILTIN.matcher(nName.id).matches()) {
            this.addStyle(nName, StyleRun.Type.BUILTIN);
            return true;
        }
        return true;
    }

    @Override
    public boolean visit(NNum nNum) {
        this.addStyle(nNum, StyleRun.Type.NUMBER);
        return true;
    }

    @Override
    public boolean visit(NStr nStr) {
        String string = this.sourceString(nStr.start(), nStr.end());
        if (TRISTRING_PREFIX.matcher(string).lookingAt()) {
            this.addStyle(nStr.start(), nStr.end() - nStr.start(), StyleRun.Type.DOC_STRING);
            this.docOffsets.add(nStr.start());
            this.highlightDocString(nStr);
        }
        return true;
    }

    private void highlightDocString(NStr nStr) {
        String string = this.sourceString(nStr.start(), nStr.end());
        DocStringParser docStringParser = new DocStringParser(string, nStr, this.linker);
        docStringParser.setResolveReferences(true);
        this.styles.addAll(docStringParser.highlight());
    }

    private void highlightLexicalTokens() {
        Token token;
        RecognizerSharedState recognizerSharedState = new RecognizerSharedState();
        recognizerSharedState.errorRecovery = true;
        PythonLexer pythonLexer = new PythonLexer(new ANTLRStringStream(this.source){

            public String getSourceName() {
                return Styler.this.path;
            }
        }, recognizerSharedState);
        pythonLexer.setErrorHandler(new RecordingErrorHandler(){

            public void error(String string, PythonTree pythonTree) {
            }

            public void reportError(BaseRecognizer baseRecognizer, RecognitionException recognitionException) {
            }
        });
        while ((token = pythonLexer.nextToken()) != Token.EOF_TOKEN) {
            switch (token.getType()) {
                case 90: {
                    int n = ((CommonToken)token).getStartIndex();
                    int n2 = ((CommonToken)token).getStopIndex();
                    if (this.docOffsets.contains(n)) break;
                    this.addStyle(n, n2 - n + 1, StyleRun.Type.STRING);
                    break;
                }
                case 96: {
                    int n = ((CommonToken)token).getStartIndex();
                    int n2 = ((CommonToken)token).getStopIndex();
                    String string = token.getText();
                    this.addStyle(n, n2 - n + 1, StyleRun.Type.COMMENT);
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: {
                    int n = ((CommonToken)token).getStartIndex();
                    int n2 = ((CommonToken)token).getStopIndex();
                    this.addStyle(n, n2 - n + 1, StyleRun.Type.KEYWORD);
                    break;
                }
            }
        }
    }

    private void addStyle(NNode nNode, int n, int n2, StyleRun.Type type) {
        if (nNode == null || nNode.getFile() == null) {
            return;
        }
        this.addStyle(n, n2, type);
    }

    private void addStyle(NNode nNode, StyleRun.Type type) {
        if (nNode != null) {
            this.addStyle(nNode, nNode.start(), nNode.end() - nNode.start(), type);
        }
    }

    private void addStyle(int n, int n2, StyleRun.Type type) {
        this.styles.add(new StyleRun(type, n, n2));
    }

    private String sourceString(NNode nNode) {
        return this.sourceString(nNode.start(), nNode.end());
    }

    private String sourceString(int n, int n2) {
        int n3 = Math.max(n, 0);
        int n4 = Math.min(n2, this.source.length());
        n4 = Math.max(n4, 0);
        try {
            return this.source.substring(n3, n4);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            System.out.println("whoops: beg=" + n3 + ", end=" + n4 + ", len=" + this.source.length());
            return "";
        }
    }
}

